<?php

namespace App\Models\Academico;

use App\Models\PivoteHorario;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Horario extends Model
{
    use HasFactory;

    protected $table = 'horarios';
    protected $fillable = ['nombre', 'hora_entrada', 'tolerancia_entrada', 'hora_salida', 'tolerancia_salida'];

    public function pivote_horarios()
    {
        return $this->hasMany(PivoteHorario::class, 'id_horario');
    }
}
