<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class VideoRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'key' => 'required|string|max:100',
            'tipo' => 'required|string|max:15',
        ];
    }

    public function messages(): array
    {
        return [
            'key.required' => 'El campo key es obligatorio.',
            'key.string' => 'El campo key debe ser una cadena de texto.',
            'key.max' => 'El campo key no debe exceder los 100 caracteres.',

            'tipo.required' => 'El campo tipo es obligatorio.',
            'tipo.string' => 'El campo tipo debe ser una cadena de texto.',
            'tipo.max' => 'El campo tipo no debe exceder los 15 caracteres.',
        ];
    }
}
