<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class PivoteHorarioCarreraEstudianteRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'id_pivote_horario' => 'required|exists:pivote_horarios,id',
            'id_universidad' => 'required|exists:universidades,id',
            'id_carrera' => 'required|exists:carreras,id',
            'estudiante.observacion' => 'nullable|string|max:255',
            'estudiante.fotografia' => 'nullable|string',
            'estudiante.id_persona' => 'required|exists:personas,id',
            'estudiante.id_colegio' => 'required|exists:colegios,id',
            'estudiante.id_apoderado' => 'nullable|exists:apoderados,id',
            'estudiante.dni_estudiante' => 'nullable|numeric',
            'estudiante.dni_apoderado' => 'required|numeric',
            'estudiante.estado_estudiante' => 'nullable|string',
            'estado_pago' => 'nullable|string',
            'estado_mensaje' => 'nullable|string',
        ];
    }

    public function messages(): array
    {
        return [
            'id_pivote_horario.required' => 'El campo horario es obligatorio.',
            'id_pivote_horario.exists' => 'El horario seleccionado no es válido.',

            'id_carrera.required' => 'El campo carrera es obligatorio.',
            'id_carrera.exists' => 'La carrera seleccionada no es válida.',

            'id_universidad.required' => 'El campo universidad es obligatorio.',
            'id_universidad.exists' => 'La universidad seleccionada no es válida.',

            'estudiante.observacion.string' => 'La observación debe ser un texto.',
            'estudiante.observacion.max' => 'La observación no puede tener más de 255 caracteres.',

            'estudiante.fotografia.string' => 'La fotografía debe ser un texto válido.',

            'estudiante.id_persona.required' => 'El campo persona del estudiante es obligatorio.',
            'estudiante.id_persona.exists' => 'La persona seleccionada no existe.',

            'estudiante.id_colegio.required' => 'El campo colegio del estudiante es obligatorio.',
            'estudiante.id_colegio.exists' => 'El colegio seleccionado no existe.',

            'estudiante.id_apoderado.exists' => 'El apoderado seleccionado no existe.',

            'estudiante.dni_estudiante.exists' => 'El estudiante con este DNI no existe.',

            'estudiante.dni_apoderado.required' => 'El DNI del apoderado es obligatorio.',
            'estudiante.dni_apoderado.exists' => 'El apoderado con este DNI no existe.',
        ];
    }
}
