<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class PivoteEncuestaDocenteRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */

    public function rules(): array
    {
        return [
            'pivote_encuesta_docente.*.id' => 'required|exists:pivote_encuestas_docentes,id',
            'pivote_encuesta_docente.*.respuesta' => 'required|numeric',
            'id_pivote_horario_carrera_estudiante' => 'required|exists:pivote_encuestas_estudiantes,id',
        ];
    }
    
    public function messages(): array
    {
        return [
            'id_pivote_horario_carrera_estudiante.required' => 'El campo estudiante es obligatorio.',
            'id_pivote_horario_carrera_estudiante.exists' => 'El campo estudiante no existe en la base de datos.',

            'pivote_encuesta_docente.*.id.required' => 'El campo ID en encuesta docente es obligatorio.',
            'pivote_encuesta_docente.*.id.exists' => 'El campo ID en encuesta docente no existe en la base de datos.',

            'pivote_encuesta_docente.*.respuesta.required' => 'El campo respuesta del estudiante es obligatorio.',
            'pivote_encuesta_docente.*.respuesta.numeric' => 'El campo respuesta del estudiante debe ser un valor numérico.',
        ];
    }
}
