<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class PivoteAreaCursoDocenteRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'id_docente' => 'required|exists:docentes,id',
            'areas.*.id' => 'required|exists:areas,id',
            'id_curso' => 'required|exists:cursos,id',
        ];
    }

    public function messages(): array
    {
        return [
            'id_docente.required' => 'El campo docente es obligatorio.',
            'id_docente.exists' => 'El docente seleccionado no es válido.',

            'areas.*.id.required' => 'El campo ID en las áreas es obligatorio.',
            'areas.*.id.exists' => 'El campo ID en las áreas no existe en la base de datos.',

            'id_curso.required' => 'El campo curso es obligatorio.',
            'id_curso.exists' => 'El curso seleccionado no es válido.',
        ];
    }
}
