<?php

namespace App\Http\Requests\Persona;

use Illuminate\Foundation\Http\FormRequest;

class EstudianteRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'observacion' => 'nullable|string|max:255',
            'fotografia' => 'nullable|string',
            'estado_estudiante' => 'nullable|string|max:10',
            'id_persona' => 'required|exists:personas,id',
            'id_colegio' => 'required|exists:colegios,id',
            'id_apoderado' => 'nullable|exists:apoderados,id',
        ];
    }

    public function messages(): array
    {
        return [
            'observacion.string' => 'La observación debe ser una cadena de texto.',
            'observacion.max' => 'La observación no puede exceder los 255 caracteres.',
            'fotografia.string' => 'La fotografía debe ser una cadena de texto.',
            'id_persona.required' => 'El campo de persona es obligatorio.',
            'id_colegio.required' => 'El campo de colegio es obligatorio.',
        ];
    }
}
