<?php

namespace App\Http\Requests\Persona;

use Illuminate\Foundation\Http\FormRequest;

class DocenteRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'observacion' => 'nullable|string|max:255',
            'fotografia' => 'nullable|string',
            'estado' => 'nullable|string|max:10',
            'id_persona' => 'required|exists:personas,id',
            'descripcion' => 'nullable|string',
        ];
    }

    public function messages(): array
    {
        return [
            'observacion.string' => 'La observación debe ser una cadena de texto.',
            'observacion.max' => 'La observación no puede exceder los 255 caracteres.',

            'fotografia.string' => 'La fotografía debe ser una cadena de texto.',

            'id_persona.required' => 'El campo de persona es obligatorio.',
            'id_persona.exists' => 'La persona seleccionada no es válida.',

            'estado.max' => 'El estado no puede exceder los 10 caracteres.',
        ];
    }
}
