<?php

namespace App\Http\Requests\Persona;

use Illuminate\Foundation\Http\FormRequest;

class ApoderadoRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'id_persona' => 'required|exists:personas,id',
        ];
    }

    public function messages(): array
    {
        return [
            'id_persona.required' => 'El campo de persona es obligatorio.',
            'id_persona.exists' => 'La persona seleccionada no es válida.',
        ];
    }
}
