<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ImagenRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'imagen' => 'required|string',
            'url' => 'nullable|string|max:100',
        ];
    }

    public function messages(): array
    {
        return [
            'imagen.required' => 'La imagen es obligatoria.',
            'imagen.string' => 'La imagen debe ser una cadena de texto válida.',
            'url.string' => 'La URL debe ser una cadena de texto válida.',
            'url.max' => 'La URL no debe exceder los 100 caracteres.',
        ];
    }
}
