<?php

namespace App\Http\Requests\Finanza;

use Illuminate\Foundation\Http\FormRequest;

class SyncPagoRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'id_pivote_horario_carrera_estudiante' => 'required|exists:pivote_horarios_carreras_estudiantes,id',
            'pagos' => 'required|array',
            'pagos.*.id' => 'required|exists:pagos,id',
        ];
    }

    /**
     * Obtiene los mensajes de error personalizados para la validación.
     */
    public function messages(): array
    {
        return [
            'id_pivote_horario_carrera_estudiante.required' => 'El campo pivote es obligatorio.',
            'id_pivote_horario_carrera_estudiante.exists' => 'El pivote seleccionado no es válido.',

            'pagos.required' => 'Debe proporcionar al menos un pago.',
            'pagos.array' => 'El campo pagos debe ser un arreglo.',
            'pagos.*.id.required' => 'Cada pago debe tener un ID.',
            'pagos.*.id.exists' => 'Uno o más pagos seleccionados no son válidos.',
        ];
    }
}
