<?php

namespace App\Http\Requests\Finanza;

use Illuminate\Foundation\Http\FormRequest;

class PagoRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'recibo' => 'required|string',
            'total' => 'required|numeric',
            'id_pivote_horario_carrera_estudiante' => 'required|exists:pivote_horarios_carreras_estudiantes,id',
            'estado_pago' => 'nullable|string',
        ];
    }

    public function messages(): array
    {
        return [
            'recibo.required' => 'El campo recibo es obligatorio.',
            'recibo.string' => 'El campo recibo debe ser una cadena de texto.',

            'total.required' => 'El campo total es obligatorio.',
            'total.numeric' => 'El campo total debe ser un número.',

            'id_pivote_horario_carrera_estudiante.required' => 'El campo pivote es obligatorio.',
            'id_pivote_horario_carrera_estudiante.exists' => 'El pivote seleccionado no es válido.',
        ];
    }
}
