<?php

namespace App\Http\Requests\Finanza;

use Illuminate\Foundation\Http\FormRequest;

class BecaRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'tipo' => 'required|string|max:50',
            'id_pivote_horario_carrera_estudiante' => 'required|exists:pivote_horarios_carreras_estudiantes,id',
        ];
    }

    public function messages(): array
    {
        return [
            'tipo.required' => 'El campo de tipo es obligatorio.',
            'tipo.string' => 'El campo de tipo debe ser una cadena de texto.',
            'tipo.max' => 'El campo de tipo no puede exceder los 50 caracteres.',
            'id_pivote_horario_carrera_estudiante.required' => 'El campo estudiante es obligatorio.',
            'id_pivote_horario_carrera_estudiante.exists' => 'El estudiante seleccionado no es válido.',
        ];
    }
}
