<?php

namespace App\Http\Requests\Evaluacion;

use Illuminate\Foundation\Http\FormRequest;

class PreguntaRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'pregunta' => 'required|string',
            'puntuacion' => 'required|integer',
            'docentes.*.id' => 'required|exists:pivote_areas_cursos_docentes,id',
        ];
    }

    public function messages(): array
    {
        return [
            'pregunta.required' => 'El campo pregunta es obligatorio.',
            'pregunta.string' => 'El campo pregunta debe ser una cadena de texto.',

            'puntuacion.required' => 'El campo puntuación es obligatorio.',
            'puntuacion.integer' => 'El campo puntuación debe ser un número entero.',

            'docentes.id*.required' => 'El campo ID en pivote áreas cursos docentes es obligatorio.',
            'docentes.id*.exists' => 'El campo ID en pivote áreas cursos docentes no existe en la base de datos.',
        ];
    }
}
