<?php

namespace App\Http\Requests\Evaluacion;

use Illuminate\Foundation\Http\FormRequest;

class NotaRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'tipo' => 'required|string|max:10',
            'nota' => 'required|numeric',
            'fecha' => 'required|date',
            'id_pivote_horario_carrera_estudiante' => 'required|exists:pivote_horarios_carreras_estudiantes,id',
        ];
    }

    public function messages(): array
    {
        return [
            'tipo.required' => 'El campo tipo es obligatorio.',
            'tipo.string' => 'El campo tipo debe ser una cadena de texto.',
            'tipo.max' => 'El campo tipo no puede exceder los 10 caracteres.',

            'fecha.required' => 'La fecha es obligatoria.',
            'fecha.date' => 'La fecha debe ser una fecha válida.',

            'nota.required' => 'El campo nota es obligatorio.',
            'nota.numeric' => 'El campo nota debe ser un número.',

            'id_pivote_horario_carrera_estudiante.required' => 'El campo pivote es obligatorio.',
            'id_pivote_horario_carrera_estudiante.exists' => 'El pivote seleccionado no es válido.',
        ];
    }
}
