<?php

namespace App\Http\Requests\Evaluacion;

use Illuminate\Foundation\Http\FormRequest;

class EncuestaRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'nombre' => 'required|string|max:100',
            'fecha_inicio' => 'required|date',
            'fecha_final' => 'required|date',
            'estado' => 'nullable|string|max:15',
            'docentes.*.id' => 'required|exists:pivote_preguntas_docentes,id',
        ];
    }

    public function messages(): array
    {
        return [
            'nombre.required' => 'El campo nombre es obligatorio.',
            'nombre.string' => 'El campo nombre debe ser una cadena de texto.',
            'nombre.max' => 'El campo nombre no puede exceder los 100 caracteres.',

            'fecha_inicio.required' => 'La fecha de inicio es obligatoria.',
            'fecha_inicio.date' => 'El campo fecha de inicio debe ser una fecha válida.',

            'fecha_final.required' => 'La fecha final es obligatoria.',
            'fecha_final.date' => 'El campo fecha final debe ser una fecha válida.',

            'docentes.id*.required' => 'La pregunta docente es obligatorio.',
            'docentes.id*.exists' => 'La pregunta docente no existe en la base de datos.',
        ];
    }
}
