<?php

namespace App\Http\Requests\Evaluacion;

use Illuminate\Foundation\Http\FormRequest;

class ConductaRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'conducta'     => 'required|string|max:20',
            'observacion'   => 'nullable|string|max:255',
            'fecha_conducta' => 'required|date',
            'id_pivote_horario_carrera_estudiante' => 'required|exists:pivote_horarios_carreras_estudiantes,id',
        ];
    }

    public function messages(): array
    {
        return [
            'conducta.required' => 'El campo de conducta es obligatorio.',
            'conducta.string'   => 'El campo de conducta debe ser una cadena de texto.',
            'conducta.max'      => 'El campo de conducta no puede exceder los 20 caracteres.',
            
            'fecha_conducta.required' => 'La fecha es obligatoria.',
            'fecha_conducta.date' => 'El campo de fecha debe ser una fecha válida.',

            'observacion.string'   => 'La observación debe ser una cadena de texto.',
            'observacion.max'      => 'La observación no puede exceder los 255 caracteres.',

            'id_pivote_horario_carrera_estudiante.required' => 'El campo de pivote es obligatorio.',
            'id_pivote_horario_carrera_estudiante.exists'   => 'El pivote seleccionado no es válido.',
        ];
    }
}
