<?php

namespace App\Http\Requests\Evaluacion;

use Illuminate\Foundation\Http\FormRequest;

class AsistenciaRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'asistencia' => 'required|string|max:10',
            'fecha_asistencia' => 'required|date',
            'hora_asistencia' => 'required|date_format:H:i:s',
            'id_pivote_horario_carrera_estudiante' => 'required|exists:pivote_horarios_carreras_estudiantes,id',
        ];
    }

    public function messages(): array
    {
        return [
            'asistencia.required' => 'El campo de asistencia es obligatorio.',
            'asistencia.string' => 'El campo de asistencia debe ser una cadena de texto.',
            'asistencia.max' => 'El campo de asistencia no puede exceder los 10 caracteres.',

            'hora_asistencia.required' => 'La hora de asistencia es obligatoria.',
            'hora_asistencia.date_format' => 'La hora de asistencia debe estar en el formato HH:MM:SS.',
        
            'fecha_asistencia.required' => 'La fecha es obligatoria.',
            'fecha_asistencia.date' => 'El campo de fecha debe ser una fecha válida.',

            'id_pivote_horario_carrera_estudiante.required' => 'El campo de pivote es obligatorio.',
            'id_pivote_horario_carrera_estudiante.exists' => 'El pivote seleccionado no es válido.',
        ];
    }
}
