<?php

namespace App\Http\Requests\Auth;

use Illuminate\Foundation\Http\FormRequest;

class CredencialRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'usuario' => 'required|string|max:255',
            'password' => 'required|string|min:4|max:255',
        ];
    }

    /**
     * Get custom messages for validation errors.
     */
    public function messages(): array
    {
        return [
            'usuario.required' => 'El campo usuario es obligatorio.',
            'usuario.max' => 'El usuario no debe exceder los 255 caracteres.',
            'password.required' => 'El campo password es obligatorio.',
            'password.min' => 'La contraseña debe tener al menos 4 caracteres.',
            'password.max' => 'La contraseña no debe exceder los 255 caracteres.',
        ];
    }
}
