<?php

namespace App\Http\Requests\Auth;

use Illuminate\Foundation\Http\FormRequest;

class AuthRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'email' => 'required|string|email|max:255',
            'password' => 'required|string|min:4|max:255',
        ];
    }
    public function messages(): array
    {
        return [
            'email.required' => 'El campo email es obligatorio.',
            'password.required' => 'El campo password es obligatorio.',
            'password.min' => 'La contraseña debe tener al menos 4 caracteres.',
        ];
    }
}
