<?php

namespace App\Http\Requests\Academico;

use Illuminate\Foundation\Http\FormRequest;

class HorarioRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'nombre' => 'required|string|max:50',
            'hora_entrada' => 'required|date_format:H:i:s',
            'hora_salida' => 'required|date_format:H:i:s|after:hora_entrada',
            'tolerancia_entrada' => 'required|integer|min:0',
            'tolerancia_salida' => 'required|integer|min:0',
        ];
    }

    public function messages(): array
    {
        return [
            'nombre.required' => 'El nombre del horario es obligatorio.',
            'nombre.string' => 'El nombre debe ser una cadena de texto.',
            'nombre.max' => 'El nombre no puede exceder los 50 caracteres.',

            'hora_entrada.required' => 'La hora de entrada es obligatoria.',
            'hora_entrada.date_format' => 'La hora de entrada debe estar en el formato HH:MM:SS.',

            'hora_salida.required' => 'La hora de salida es obligatoria.',
            'hora_salida.date_format' => 'La hora de salida debe estar en el formato HH:MM:SS.',
            'hora_salida.after' => 'La hora de salida debe ser después de la hora de entrada.',

            'tolerancia_entrada.required' => 'La tolerancia de entrada es obligatoria.',
            'tolerancia_entrada.integer' => 'La tolerancia de entrada debe ser un número entero.',
            'tolerancia_entrada.min' => 'La tolerancia de entrada debe ser mayor o igual a 0.',

            'tolerancia_salida.required' => 'La tolerancia de salida es obligatoria.',
            'tolerancia_salida.integer' => 'La tolerancia de salida debe ser un número entero.',
            'tolerancia_salida.min' => 'La tolerancia de salida debe ser mayor o igual a 0.',

        ];
    }
}
