<?php

namespace App\Http\Requests\Academico;

use Illuminate\Foundation\Http\FormRequest;

class CicloRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'nombre' => 'required|string|max:50',
            'fecha_inicio' => 'required|date',
            'fecha_final' => 'required|date|after_or_equal:fecha_inicio',
            'estado' => 'nullable|string|max:10',
            'horarios.*.id' => 'required|exists:horarios,id',
        ];
    }

    public function messages(): array
    {
        return [
            'nombre.required' => 'El nombre del ciclo es obligatorio.',
            'nombre.string' => 'El nombre debe ser una cadena de texto.',
            'nombre.max' => 'El nombre no puede exceder los 50 caracteres.',

            'fecha_inicio.required' => 'La fecha de inicio es obligatoria.',
            'fecha_inicio.date' => 'La fecha de inicio debe ser una fecha válida.',

            'fecha_final.required' => 'La fecha de finalización es obligatoria.',
            'fecha_final.date' => 'La fecha de finalización debe ser una fecha válida.',
            'fecha_final.after_or_equal' => 'La fecha de finalización debe ser igual o posterior a la fecha de inicio.',

            'estado.string' => 'El estado debe ser una cadena de texto.',
            'estado.max' => 'El estado no puede exceder los 10 caracteres.',

            'horarios.id*.required' => 'La horario es obligatorio.',
            'horarios.id*.exists' => 'La horario no existe en la base de datos.',
        ];
    }
}
