<?php

namespace App\Http\Controllers;

use App\Services\SendWhatsappMessageService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

class WhatsappController extends Controller
{
    protected $whatsapp;
    protected $messageEstudianteCron;
    protected $messageApoderadoCron;
    protected $urlLogo;

    public function __construct(SendWhatsappMessageService $whatsapp)
    {
        $this->whatsapp = $whatsapp;
        $this->messageEstudianteCron = "Tu opinión es muy importante para nosotros. Responde la encuesta docente y contribuye a mejorar tu experiencia académica. Accede ahora a nuestra plataforma de encuestas.
        Atentamente,
        Funcionarios del Instituto de la Cultura";
        $this->messageApoderadoCron = '¡Felicitaciones por llegar al final del ciclo académico! Tu esfuerzo y compromiso te llevarán lejos.
        Te deseamos muchos éxitos en lo que viene.
        ¡Sigue adelante!, Atentamente,
        Ing. César Augusto Damas Laurente
        Alcalde';
        $this->urlLogo = 'https://scontent.fjau2-1.fna.fbcdn.net/v/t39.30808-6/412359089_122118061736119541_5846535484010072934_n.jpg?_nc_cat=109&ccb=1-7&_nc_sid=6ee11a&_nc_ohc=UUFM-LGLhmEQ7kNvgFnFYyE&_nc_zt=23&_nc_ht=scontent.fjau2-1.fna&_nc_gid=A6iSu4ClSOqdDsw08tLAzMb&oh=00_AYCXgJRRuzKmyxsuvQzZtZxKD44thpSohQYr_sgGn8Jmnw&oe=6751EE7A';
    }
    public function sendMessageWelcomeEstudiante(string $number, Request $request)
    {
        try {
          
            $nombres = $request->estudiante['nombres'] ?? '';
            $apellidoPaterno = $request->estudiante['apellido_paterno'] ?? '';
            $apellidoMaterno = $request->estudiante['apellido_materno'] ?? '';

            $messageWelcomeEstudiante = '¡Bienvenid@ a la Academia Municipal, ' . $nombres . ' ' . $apellidoPaterno . ' ' . $apellidoMaterno . '!' . ' \n' . 'Este es el inicio de un camino lleno de aprendizajes.' . ' \n' . 'Esfuérzate cada día y recuerda que tu dedicación será la clave para alcanzar tus metas.' . ' \n' . '🌐 https://academia.munichilca.gob.pe/login?estudiante/' . ' \n' . 'Atentamente,' . ' \n' . 'Ing. César Augusto Damas Laurente' . ' \n' . 'Alcalde.';

            $this->whatsapp->sendMessage('51' . $number, $messageWelcomeEstudiante);

            return response()->json(['message' => 'Mensaje al estudiante enviado.']);
        } catch (\Exception $e) {
            Log::error('Error enviando mensaje de bienvenida al estudiante: ' . $e->getMessage());
            return response()->json(['message' => 'Error al enviar el WhatsApp de bienvenida'], 500);
        }
    }

    public function sendMessageWelcomeApoderado(string $number, Request $request)
    {
        try {
            $nombres = $request->apoderado['nombres'] ?? '';
            $apellidoPaterno = $request->apoderado['apellido_paterno'] ?? '';
            $apellidoMaterno = $request->apoderado['apellido_materno'] ?? '';

            $messageWelcomeApoderado = '¡Estimad@ apoderad@, ' . $nombres . ' ' . $apellidoPaterno . ' ' . $apellidoMaterno . '!' . ' \n' . 'En la Academia Municipal, creemos que la educación es un esfuerzo de todos.' . ' \n' . 'Su compromiso y apoyo son fundamentales para el éxito de sus hij@s. ' . ' \n' . 'Ahora puede consultar las notas, asistencias y conductas ingresando a nuestra página web:' . ' \n' . '🌐 https://academia.munichilca.gob.pe/login?estudiante/' . ' \n' . 'Atentamente, ' . ' \n' . 'Ing. César Augusto Damas Laurente' . ' \n' . 'Alcalde';

            $this->whatsapp->sendMessage('51' . $number, $messageWelcomeApoderado);
            return response()->json(['message' => 'Mensaje al apoderado enviado.']);
        } catch (\Exception $e) {
            Log::error('Error enviando mensaje de bienvenida al apoderado: ' . $e->getMessage());
            return response()->json(['message' => 'Error al enviar el WhatsApp de bienvenida'], 500);
        }
    }

    public function sendMessageEstudianteCron(string $number)
    {
        try {
            $this->whatsapp->sendMessage('51' . $number, $this->messageEstudianteCron, $this->urlLogo);
        } catch (\Exception $e) {
            Log::error('Error enviando mensaje al estudiante: ' . $e->getMessage());
        }
    }

    public function sendMessageApoderadoCron(string $number)
    {
        try {
            $this->whatsapp->sendMessage('51' . $number, $this->messageApoderadoCron, $this->urlLogo);
        } catch (\Exception $e) {
            Log::error('Error enviando mensaje al apoderado: ' . $e->getMessage());
        }
    }
}
