<?php

namespace App\Http\Controllers;

use App\Http\Requests\VideoRequest;
use App\Models\Video;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;


class VideoController extends Controller
{
    public function getAll(Request $request): JsonResponse
    {
        $pagination = $request->input('pagination', 10);
        $query = Video::query();

        $videos = $query->latest()->paginate($pagination);

        return response()->json(
            [
                'videos' => $videos,
            ],
            200,
        );
    }

    public function show($id): JsonResponse
    {
        $videos = Video::where('id_pivote_horario_carrera_estudiante', $id)->get();
        return response()->json(
            [
                'videos' => $videos,
                'message' => 'Las videos se han obtenido exitosamente!',
            ],
            200,
        );
    }

    public function save(VideoRequest $request): JsonResponse
    {
        $video = Video::create($request->validated());
        $video->save();
        return response()->json(
            [
                'video' => $video,
                'message' => 'El video se ha creado exitosamente!.',
            ],
            201,
        );
    }

    public function update($id, VideoRequest $request): JsonResponse
    {
        $video = Video::findOrFail($id);

        if (!$video) {
            return response()->json(['message' => 'El video no encontrado.'], 404);
        }

        $video->update($request->validated());
        $video->save();

        return response()->json(
            [
                'video' => $video,
                'message' => 'El video se ha actualizado exitosamente!.',
            ],
            200,
        );
    }

    public function delete($id): JsonResponse
    {
        $video = Video::findOrFail($id);

        if (!$video) {
            return response()->json(['message' => 'Video no encontrado.'], 404);
        }

        $video->delete();

        return response()->json(
            [
                'message' => 'El video se ha eliminado exitosamente!.',
            ],
            200,
        );
    }
}
