<?php

namespace App\Http\Controllers;

use App\Http\Requests\PivotePreguntaDocenteRequest;
use App\Models\PivotePreguntaDocente;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use Illuminate\Database\Eloquent\Builder;


class PivotePreguntaDocenteController extends Controller
{

    public function paramDocente(Builder $query, string $docente): Builder
    {
        if ($docente === 'VIGENTE') {
            $query->whereHas('pivote_area_curso_docente.docente', function ($q) use ($docente) {
                $q->where('estado', 'like', "%$docente%");
            });
        }
        return $query;
    }


    public function getAll(Request $request): JsonResponse
    {
        $query = PivotePreguntaDocente::query();
        $pagination = $request->input('pagination', 10);
        $params = $request->input('param', []);

        if (!empty($params['docente'])) {
            $query = $this->paramDocente($query, $params['docente']);
        }

        $pivote_pregunta_docentes = $query->with('pregunta', 'pivote_area_curso_docente.docente.persona', 'pivote_area_curso_docente.area', 'pivote_area_curso_docente.curso', 'pivote_encuestas_docentes')->latest()->paginate($pagination)->appends($request->query());

        return response()->json(
            [
                'pivote_pregunta_docentes' => $pivote_pregunta_docentes,
                'params' => $request->query() ?: null,
            ],
            200,
        );
    }

    public function show($id): JsonResponse
    {
        $pivote_pregunta_docente = PivotePreguntaDocente::findOrFail($id);

        if (!$pivote_pregunta_docente) {
            return response()->json(['message' => 'PivotePreguntaDocente no encontrado.'], 404);
        }

        return response()->json(
            [
                'pivote_pregunta_docente' => $pivote_pregunta_docente,
                'message' => 'PivotePreguntaDocente: ' . $pivote_pregunta_docente->nombre . ', encontrado exitosamente!.',
            ],
            200,
        );
    }

    public function save(PivotePreguntaDocenteRequest $request): JsonResponse
    {
        $pivote_pregunta_docente = PivotePreguntaDocente::create($request->validated());

        $pivote_pregunta_docente->save();

        return response()->json(
            [
                'pivote_pregunta_docente' => $pivote_pregunta_docente,
                'message' => 'El pivote_pregunta_docente: ' . $pivote_pregunta_docente->nombre . ', se ha creado exitosamente!.',
            ],
            201,
        );
    }

    public function update($id, PivotePreguntaDocenteRequest $request): JsonResponse
    {
        $pivote_pregunta_docente = PivotePreguntaDocente::findOrFail($id);

        if (!$pivote_pregunta_docente) {
            return response()->json(['message' => 'El pivote_pregunta_docente' . $request->nombre . ', no encontrado.'], 404);
        }

        $pivote_pregunta_docente->update($request->validated());
        $pivote_pregunta_docente->save();

        return response()->json(
            [
                'pivote_pregunta_docente' => $pivote_pregunta_docente,
                'message' => 'El pivote_pregunta_docente: ' . $pivote_pregunta_docente->nombre . ', se ha actualizado exitosamente!.',
            ],
            200,
        );
    }

    public function delete($id): JsonResponse
    {
        $pivote_pregunta_docente = PivotePreguntaDocente::findOrFail($id);

        if (!$pivote_pregunta_docente) {
            return response()->json(['message' => 'PivotePreguntaDocente no encontrado.'], 404);
        }

        $pivote_pregunta_docente->delete();

        return response()->json(
            [
                'message' => 'El pivote_pregunta_docente: ' . $pivote_pregunta_docente->nombre . ', se ha eliminado exitosamente!.',
            ],
            200,
        );
    }
}
