<?php

namespace App\Http\Controllers;

use App\Http\Requests\PivoteHorarioRequest;
use App\Models\PivoteHorario;
use App\Services\SearchHorarioCiclo;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;

class PivoteHorarioController extends Controller
{
    protected $searchHorarioCiclo;

    public function __construct(SearchHorarioCiclo $searchHorarioCiclo)
    {
        $this->searchHorarioCiclo = $searchHorarioCiclo;
    }

    public function getAll(Request $request): JsonResponse
    {
        $pagination = $request->input('pagination', 10);
        $search = $request->input('search', '');
        $estados = $request->input('param.estados', []);
        $hora = $request->input('param.hora', null);

        $query = $this->searchHorarioCiclo->buscarHorarioCiclo($search, $estados, $hora);

        $pivote_horarios = $query->with('horario', 'ciclo', 'pivote_horarios_carreras_estudiantes')
            ->latest()
            ->paginate($pagination)
            ->appends($request->query());

        return response()->json(
            [
                'pivote_horarios' => $pivote_horarios,
                'params' => $request->query() ?: null,
            ],
            200,
        );
    }

    public function show($id): JsonResponse
    {
        $pivote_horario = PivoteHorario::findOrFail($id);

        if (!$pivote_horario) {
            return response()->json(['message' => 'PivoteHorario no encontrado.'], 404);
        }

        return response()->json(
            [
                'pivote_horario' => $pivote_horario,
                'message' => 'PivoteHorario: ' . $pivote_horario->nombre . ', encontrado exitosamente!.',
            ],
            200,
        );
    }

    public function save(PivoteHorarioRequest $request): JsonResponse
    {
        $pivote_horario = PivoteHorario::create($request->validated());

        $pivote_horario->save();

        return response()->json(
            [
                'pivote_horario' => $pivote_horario,
                'message' => 'El pivote_horario: ' . $pivote_horario->nombre . ', se ha creado exitosamente!.',
            ],
            201,
        );
    }

    public function update($id, PivoteHorarioRequest $request): JsonResponse
    {
        $pivote_horario = PivoteHorario::findOrFail($id);

        if (!$pivote_horario) {
            return response()->json(['message' => 'El pivote_horario' . $request->nombre . ', no encontrado.'], 404);
        }

        $pivote_horario->update($request->validated());
        $pivote_horario->save();

        return response()->json(
            [
                'pivote_horario' => $pivote_horario,
                'message' => 'El pivote_horario: ' . $pivote_horario->nombre . ', se ha actualizado exitosamente!.',
            ],
            200,
        );
    }

    public function delete($id): JsonResponse
    {
        $pivote_horario = PivoteHorario::findOrFail($id);

        if (!$pivote_horario) {
            return response()->json(['message' => 'PivoteHorario no encontrado.'], 404);
        }

        $pivote_horario->delete();

        return response()->json(
            [
                'message' => 'El pivote_horario: ' . $pivote_horario->nombre . ', se ha eliminado exitosamente!.',
            ],
            200,
        );
    }
}
