<?php

namespace App\Http\Controllers;

use App\Http\Requests\PivoteEncuestaEstudianteRequest;
use App\Models\PivoteEncuestaEstudiante;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;

class PivoteEncuestaEstudianteController extends Controller
{
    public function getAll(Request $request): JsonResponse
    {
        $query = PivoteEncuestaEstudiante::query();
        $pagination = $request->input('pagination', 10);

        $pivote_encuesta_estudiantes = $query->with('pivote_encuesta_docente.pivote_pregunta_docente.pregunta')->latest()->paginate($pagination)->appends($request->query());

        return response()->json(
            [
                'pivote_encuesta_estudiantes' => $pivote_encuesta_estudiantes,
                'params' => $request->query() ?: null,
            ],
            200,
        );
    }

    public function show($id): JsonResponse
    {
        $pivote_encuesta_estudiante = PivoteEncuestaEstudiante::findOrFail($id);

        if (!$pivote_encuesta_estudiante) {
            return response()->json(['message' => 'La encuesta estudiante no encontrado.'], 404);
        }
        $pivote_encuesta_estudiante->load('pivote_encuesta_docente.pivote_pregunta_docente.pregunta');

        return response()->json(
            [
                'pivote_encuesta_estudiante' => $pivote_encuesta_estudiante,
                'message' => 'La encuesta estudiante: ' . $pivote_encuesta_estudiante->nombre . ', encontrado exitosamente!.',
            ],
            200,
        );
    }

    public function save(PivoteEncuestaEstudianteRequest $request): JsonResponse
    {
        foreach ($request['pivote_encuestas_docentes'] as $pivote_encuesta_docente) {
            PivoteEncuestaEstudiante::create([
                'respuesta' => $pivote_encuesta_docente['respuesta'],
                'id_pivote_encuesta_docente' => $pivote_encuesta_docente['id'],
                'id_pivote_horario_carrera_estudiante' => $request['id_pivote_horario_carrera_estudiante'],
            ]);
        }
        return response()->json(
            [
                'message' => 'Se realizó la encuesta exitosamente!',
            ],
            201,
        );
    }

    public function update($id, PivoteEncuestaEstudianteRequest $request): JsonResponse
    {
        $pivote_encuesta_estudiante = PivoteEncuestaEstudiante::findOrFail($id);

        if (!$pivote_encuesta_estudiante) {
            return response()->json(['message' => 'La encuesta estudiante ' . $request->nombre . ', no encontrado.'], 404);
        }

        $pivote_encuesta_estudiante->update($request->validated());
        $pivote_encuesta_estudiante->save();

        return response()->json(
            [
                'pivote_encuesta_estudiante' => $pivote_encuesta_estudiante,
                'message' => 'La encuesta estudiante: ' . $pivote_encuesta_estudiante->nombre . ', se ha actualizado exitosamente!.',
            ],
            200,
        );
    }

    public function delete($id): JsonResponse
    {
        $pivote_encuesta_estudiante = PivoteEncuestaEstudiante::findOrFail($id);

        if (!$pivote_encuesta_estudiante) {
            return response()->json(['message' => 'La encuesta estudiante no encontrado.'], 404);
        }

        $pivote_encuesta_estudiante->delete();

        return response()->json(
            [
                'message' => 'La encuesta estudiante: ' . $pivote_encuesta_estudiante->nombre . ', se ha eliminado exitosamente!.',
            ],
            200,
        );
    }
}
