<?php

namespace App\Http\Controllers;

use App\Http\Requests\PivoteEncuestaDocenteRequest;
use App\Models\PivoteEncuestaDocente;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;

class PivoteEncuestaDocenteController extends Controller
{
    public function getAll(Request $request): JsonResponse
    {
        $query = PivoteEncuestaDocente::query();
        $pagination = $request->input('pagination', 10);

        $pivote_encuesta_docentes = $query->with('encuesta', 'pivote_pregunta_docente.pivote_area_curso_docente.docente.persona', 'pivote_pregunta_docente.pregunta', 'pivote_encuestas_estudiantes')->latest()->paginate($pagination)->appends($request->query());

        return response()->json(
            [
                'pivote_encuesta_docentes' => $pivote_encuesta_docentes,
                'params' => $request->query() ?: null,
            ],
            200,
        );
    }

    public function show($id): JsonResponse
    {
        $pivote_encuesta_docente = PivoteEncuestaDocente::findOrFail($id);

        if (!$pivote_encuesta_docente) {
            return response()->json(['message' => 'PivoteEncuestaDocente no encontrado.'], 404);
        }

        return response()->json(
            [
                'pivote_encuesta_docente' => $pivote_encuesta_docente,
                'message' => 'La encuesta docente: ' . $pivote_encuesta_docente->nombre . ', encontrado exitosamente!.',
            ],
            200,
        );
    }

    public function save(PivoteEncuestaDocenteRequest $request): JsonResponse
    {
        $pivote_encuesta_docente = PivoteEncuestaDocente::create($request->validated());

        $pivote_encuesta_docente->save();

        return response()->json(
            [
                'pivote_encuesta_docente' => $pivote_encuesta_docente,
                'message' => 'La encuesta docente: ' . $pivote_encuesta_docente->nombre . ', se ha creado exitosamente!.',
            ],
            201,
        );
    }

    public function update($id, PivoteEncuestaDocenteRequest $request): JsonResponse
    {
        $pivote_encuesta_docente = PivoteEncuestaDocente::findOrFail($id);

        if (!$pivote_encuesta_docente) {
            return response()->json(['message' => 'La encuesta docente' . $request->nombre . ', no encontrado.'], 404);
        }

        $pivote_encuesta_docente->update($request->validated());
        $pivote_encuesta_docente->save();

        return response()->json(
            [
                'pivote_encuesta_docente' => $pivote_encuesta_docente,
                'message' => 'La encuesta docente: ' . $pivote_encuesta_docente->nombre . ', se ha actualizado exitosamente!.',
            ],
            200,
        );
    }

    public function delete($id): JsonResponse
    {
        $pivote_encuesta_docente = PivoteEncuestaDocente::findOrFail($id);

        if (!$pivote_encuesta_docente) {
            return response()->json(['message' => 'PivoteEncuestaDocente no encontrado.'], 404);
        }

        $pivote_encuesta_docente->delete();

        return response()->json(
            [
                'message' => 'La encuesta docente: ' . $pivote_encuesta_docente->nombre . ', se ha eliminado exitosamente!.',
            ],
            200,
        );
    }
}
