<?php

namespace App\Http\Controllers\Persona;

use App\Http\Controllers\Controller;
use App\Http\Requests\Persona\ApoderadoRequest;
use App\Models\Persona\Apoderado;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class ApoderadoController extends Controller
{

    public function getAll(Request $request): JsonResponse
    {
        $query = Apoderado::query();
        $pagination = $request->input('pagination', 10);
        $apoderados = $query->paginate($pagination)->appends($request->query());

        return response()->json(
            [
                'apoderados' => $apoderados,
                'params' => $request->query() ?: null,
            ],
            200,
        );
    }

    public function show($id): JsonResponse
    {
        $apoderado = Apoderado::findOrFail($id);
       
        if (!$apoderado) {
            return response()->json(['message' => 'Apoderado no encontrado.'], 404);
        }
        $apoderado->load('Persona');
        return response()->json(
            [
                'apoderado' => $apoderado,
                'message' => 'Apoderado: ' . $apoderado->nombre . ', encontrado exitosamente!.',
            ],
            200,
        );
    }

    public function save(ApoderadoRequest $request): JsonResponse
    {
        $apoderado = Apoderado::create($request->validated());
        $apoderado->save();
        $apoderado->load('Persona');
        return response()->json(
            [
                'apoderado' => $apoderado,
                'message' => 'El apoderado: ' . $apoderado->nombre . ', se ha creado exitosamente!.',
            ],
            201,
        );
    }

    public function update($id, ApoderadoRequest $request): JsonResponse
    {
        $apoderado = Apoderado::findOrFail($id);

        if (!$apoderado) {
            return response()->json(['message' => 'El apoderado' . $request->nombre . ', no encontrado.'], 404);
        }

        $apoderado->update($request->validated());
        $apoderado->save();
        $apoderado->load('Persona');
        
        return response()->json(
            [
                'apoderado' => $apoderado,
                'message' => 'El apoderado: ' . $apoderado->nombre . ', se ha actualizado exitosamente!.',
            ],
            200,
        );
    }

    public function delete($id): JsonResponse
    {
        $apoderado = Apoderado::findOrFail($id);

        if (!$apoderado) {
            return response()->json(['message' => 'Apoderado no encontrado.'], 404);
        }

        $apoderado->delete();

        return response()->json(
            [
                'message' => 'El apoderado: ' . $apoderado->nombre . ', se ha eliminado exitosamente!.',
            ],
            200,
        );
    }
}
