<?php

namespace App\Http\Controllers;

use App\Http\Requests\ImagenRequest;
use App\Models\Imagen;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;

class ImagenController extends Controller
{
    public function getAll(Request $request): JsonResponse
    {
        $pagination = $request->input('pagination', 10);
        $query = Imagen::query();

        $imagenes = $query->latest()->paginate($pagination);

        return response()->json(
            [
                'imagenes' => $imagenes,
            ],
            200,
        );
    }

    public function show($id): JsonResponse
    {
        $imagenes = Imagen::where('id_pivote_horario_carrera_estudiante', $id)->get();
        return response()->json(
            [
                'imagenes' => $imagenes,
                'message' => 'Las imagenes se han obtenido exitosamente!',
            ],
            200,
        );
    }

    public function save(ImagenRequest $request): JsonResponse
    {
        $imagen = Imagen::create($request->validated());
        $imagen->save();
        return response()->json(
            [
                'imagen' => $imagen,
                'message' => 'El imagen se ha creado exitosamente!.',
            ],
            201,
        );
    }

    public function update($id, ImagenRequest $request): JsonResponse
    {
        $imagen = Imagen::findOrFail($id);

        if (!$imagen) {
            return response()->json(['message' => 'El imagen no encontrado.'], 404);
        }

        $imagen->update($request->validated());
        $imagen->save();

        return response()->json(
            [
                'imagen' => $imagen,
                'message' => 'El imagen se ha actualizado exitosamente!.',
            ],
            200,
        );
    }

    public function delete($id): JsonResponse
    {
        $imagen = Imagen::findOrFail($id);

        if (!$imagen) {
            return response()->json(['message' => 'Imagen no encontrado.'], 404);
        }

        $imagen->delete();

        return response()->json(
            [
                'message' => 'El imagen se ha eliminado exitosamente!.',
            ],
            200,
        );
    }
}
