<?php

namespace App\Http\Controllers;

use App\Models\PivoteHorarioCarreraEstudiante;
use BaconQrCode\Renderer\GDLibRenderer;
use BaconQrCode\Writer;
use Barryvdh\DomPDF\Facade\Pdf;

class ExportPdfsController extends Controller
{
    public function exportCarnetEstudiantePdf($id)
    {
        $pivote_horario_carrera_estudiante = PivoteHorarioCarreraEstudiante::find($id);
        if (!$pivote_horario_carrera_estudiante) {
            return response()->json(['message' => 'El carnet no encontrado.'], 404);
        }
        $nombrepdf = str_replace([' ', ',', '.', '/', '\\', '@', '#', '$', '%', '^', '&', '*', '(', ')', '[', ']', '{', '}', '|', '!', '?', '\'', '"', '\\\\'], '_', $pivote_horario_carrera_estudiante->id . '_' . $pivote_horario_carrera_estudiante->estudiante->persona->dni . '_' . $pivote_horario_carrera_estudiante->pivote_horario->ciclo->estado);
        $renderer = new GDLibRenderer(400);
        $writer = new Writer($renderer);
        $codigoQR = $writer->writeString($pivote_horario_carrera_estudiante->estudiante->persona->dni);
        if (empty($pivote_horario_carrera_estudiante->estudiante->persona->dni)) {
            $pivote_horario_carrera_estudiante->codigoQR = null;
        } else {
            $codigoQR = $writer->writeString('{dni:' . $pivote_horario_carrera_estudiante->estudiante->persona->dni . ',
procedure_queue:' . $pivote_horario_carrera_estudiante->id . '}');
            $pivote_horario_carrera_estudiante->codigoQR = base64_encode($codigoQR);
        }

        $pdf = Pdf::loadView('Exports.carnet-pdf', compact('pivote_horario_carrera_estudiante'));
        $pdf->setPaper('A4', 'portrait');

        return $pdf->stream($nombrepdf . '.pdf', [
            'Content-Type' => 'application/pdf',
            'Content-Disposition' => 'inline; filename="' . $nombrepdf . '.pdf"',
        ]);
    }
}
