<?php

namespace App\Http\Controllers\Evaluacion;

use App\Http\Controllers\Controller;
use App\Http\Requests\Evaluacion\ConductaRequest;
use App\Models\Evaluacion\Conducta;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class ConductaController extends Controller
{
    private function applyFilters(Request $request): Builder
    {
        $query = Conducta::query();

        if ($search = $request->input('search')) {
            $query->where('conducta', 'like', "%$search%");
        }

        if ($param = $request->input('param.id_pivote_horario_carrera_estudiante')) {
            $query->where('id_pivote_horario_carrera_estudiante', $param);
        }

        return $query;
    }

    public function getAll(Request $request): JsonResponse
    {
        $pagination = $request->input('pagination', 10);
        $query = $this->applyFilters($request);

        $conductas = $query->latest()->paginate($pagination)->appends($request->query());

        return response()->json(
            [
                'conductas' => $conductas,
                'params' => $request->query() ?: null,
            ],
            200,
        );
    }

    public function show($id): JsonResponse
    {
        $conductas = Conducta::where('id_pivote_horario_carrera_estudiante', $id)->get();
        return response()->json(
            [
                'conductas' => $conductas,
                'message' => 'Las conductas se han obtenido exitosamente!',
            ],
            200,
        );
    }

    public function save(ConductaRequest $request): JsonResponse
    {
        $conducta = Conducta::create($request->validated());
        $conducta->save();
        return response()->json(
            [
                'conducta' => $conducta,
                'message' => 'El conducta: ' . $conducta->conducta . ', se ha creado exitosamente!.',
            ],
            201,
        );
    }

    public function update($id, ConductaRequest $request): JsonResponse
    {
        $conducta = Conducta::findOrFail($id);

        if (!$conducta) {
            return response()->json(['message' => 'El conducta' . $request->conducta . ', no encontrado.'], 404);
        }

        $conducta->update($request->validated());
        $conducta->save();

        return response()->json(
            [
                'conducta' => $conducta,
                'message' => 'El conducta: ' . $conducta->conducta . ', se ha actualizado exitosamente!.',
            ],
            200,
        );
    }

    public function delete($id): JsonResponse
    {
        $conducta = Conducta::findOrFail($id);

        if (!$conducta) {
            return response()->json(['message' => 'Conducta no encontrado.'], 404);
        }

        $conducta->delete();

        return response()->json(
            [
                'message' => 'El conducta: ' . $conducta->conducta . ', se ha eliminado exitosamente!.',
            ],
            200,
        );
    }
}
