<?php

namespace App\Http\Controllers\Evaluacion;

use App\Http\Controllers\Controller;
use App\Http\Requests\Evaluacion\AsistenciaRequest;
use App\Models\Evaluacion\Asistencia;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class AsistenciaController extends Controller
{
    private function applyFilters(Request $request): Builder
    {
        $query = Asistencia::query();

        if ($search = $request->input('search')) {
            $query->where('asistencia', 'like', "%$search%");
        }

        if ($param = $request->input('param.id_pivote_horario_carrera_estudiante')) {
            $query->where('id_pivote_horario_carrera_estudiante', $param);
        }

        return $query;
    }

    public function getAll(Request $request): JsonResponse
    {
        $pagination = $request->input('pagination', 10);
        $query = $this->applyFilters($request);

        $asistencias = $query->latest()->paginate($pagination)->appends($request->query());

        return response()->json(
            [
                'asistencias' => $asistencias,
                'params' => $request->query() ?: null,
            ],
            200,
        );
    }

    public function show($id): JsonResponse
    {
        $asistencias = Asistencia::where('id_pivote_horario_carrera_estudiante', $id)->get();
        return response()->json(
            [
                'asistencias' => $asistencias,
                'message' => 'Las asistencias se han obtenido exitosamente!',
            ],
            200,
        );
    }

    public function save(AsistenciaRequest $request): JsonResponse
    {
        $asistencia = Asistencia::create($request->validated());
        $asistencia->save();
        return response()->json(
            [
                'asistencia' => $asistencia,
                'message' => 'El asistencia: ' . $asistencia->asistencia . ', se ha registrado exitosamente!.',
            ],
            201,
        );
    }

    public function update($id, AsistenciaRequest $request): JsonResponse
    {
        $asistencia = Asistencia::findOrFail($id);

        if (!$asistencia) {
            return response()->json(['message' => 'El asistencia' . $request->asistencia . ', no encontrado.'], 404);
        }

        $asistencia->update($request->validated());
        $asistencia->save();

        return response()->json(
            [
                'asistencia' => $asistencia,
                'message' => 'El asistencia: ' . $asistencia->asistencia . ', se ha actualizado exitosamente!.',
            ],
            200,
        );
    }

    public function delete($id): JsonResponse
    {
        $asistencia = Asistencia::findOrFail($id);

        if (!$asistencia) {
            return response()->json(['message' => 'Asistencia no encontrado.'], 404);
        }

        $asistencia->delete();

        return response()->json(
            [
                'message' => 'El asistencia: ' . $asistencia->asistencia . ', se ha eliminado exitosamente!.',
            ],
            200,
        );
    }
}
