<?php

namespace App\Exports;

use App\Models\PivoteHorarioCarreraEstudiante;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\Exportable;

class EstudiantesExport implements FromView, ShouldAutoSize
{
    use Exportable;

    protected $id_ciclo;

    public function __construct($id_ciclo)
    {
        $this->id_ciclo = $id_ciclo;
    }

    /**
     * @return \Illuminate\Support\Collection
     */
    public function view(): View
    {
        $pivote_horarios_carreras_estudiantes = PivoteHorarioCarreraEstudiante::join('estudiantes', 'pivote_horarios_carreras_estudiantes.id_estudiante', '=', 'estudiantes.id')
            ->join('personas', 'estudiantes.id_persona', '=', 'personas.id')
            ->whereIn('id_pivote_horario', function ($query) {
                $query->select('id')
                    ->from('pivote_horarios')
                    ->where('id_ciclo', $this->id_ciclo);
            })
            ->orderBy('personas.apellido_paterno')
            ->get();

        $pivote_horarios_carreras_estudiantes->load('carrera', 'universidad', 'pivote_horario', 'estudiante.persona', 'estudiante.apoderado.persona', 'pagos', 'becas', 'pivote_encuesta_estudiante');

        return view('exports.estudiantes-excel', [
            'pivote_horarios_carreras_estudiantes' => $pivote_horarios_carreras_estudiantes,
        ]);
    }
}
