<?php

namespace App\Exports;

use App\Models\PivoteHorarioCarreraEstudiante;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\Exportable;

class EstudianteExport implements FromView, ShouldAutoSize
{
    use Exportable;

    protected $id_pivote_horario_carrera_estudiante;

    public function __construct($id_pivote_horario_carrera_estudiante)
    {
        $this->id_pivote_horario_carrera_estudiante = $id_pivote_horario_carrera_estudiante;
    }

    /**
     * @return \Illuminate\Support\Collection
     */
    public function view(): View
    {
        $pivote_horario_carrera_estudiante = PivoteHorarioCarreraEstudiante::with(['estudiante.personas', 'notas', 'horario.ciclo'])->findOrFail($this->id_pivote_horario_carrera_estudiante);
        if (!$pivote_horario_carrera_estudiante) {
            return response()->json(['message' => 'El excel no encontrado.'], 404);
        }
        return view('exports.estudiantes_excel', [
            'pivote_horario_carrera_estudiante' => collect([$pivote_horario_carrera_estudiante]),
        ]);
    }
}
