<?php

namespace App\Console\Commands;

use App\Http\Controllers\WhatsappController;
use App\Models\Academico\Ciclo;
use App\Models\PivoteHorarioCarreraEstudiante;
use Illuminate\Console\Command;

class WhatsAppCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:whats-app-command';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */

    public function handle()
    {
        try {
            // Resolver el controlador desde el contenedor de servicios
            $whatsappController = app(WhatsappController::class);

            // Obtener el ciclo vigente más reciente
            $ciclo = Ciclo::where('estado', 'VIGENTE')->latest()->first();

            if (!$ciclo) {
                $this->error('No hay ciclos vigentes.');
                return;
            }

            // Obtener estudiantes del ciclo vigente
            $pivotes = PivoteHorarioCarreraEstudiante::with(['horario.ciclo', 'estudiante.persona'])
                ->whereHas('horario.ciclo', function ($query) use ($ciclo) {
                    $query->where('id', $ciclo->id);
                })
                ->get();

            foreach ($pivotes as $pivote) {
                $celular = $pivote->estudiante->persona->celular;

                if ($celular) {
                    $whatsappController->sendMessageEstudianteCron($celular);
                    sleep(10);
                }
            }

        } catch (\Exception $e) {
            info('Error durante la ejecución del comando: ' . $e->getMessage());
        }
    }
}
